<?php
ob_start();
require "_App/Config.inc.php";

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *'); // Permite requisições de qualquer origem (para desenvolvimento)
header('Access-Control-Allow-Methods: GET');

$arrContextOptions=array(
    "ssl"=>array(
        "verify_peer"=>false,
        "verify_peer_name"=>false,
    ),
);

$url = "https://www.ojogodobicho.com/deu_no_poste.htm";

try {
    $html = file_get_contents($url, false, stream_context_create($arrContextOptions));

    if ($html === false) {
        throw new Exception("Falha ao acessar a URL.");
    }

    $dom = new DOMDocument();
    libxml_use_internal_errors(true); // Desativa erros internos para parsing
    $dom->loadHTML($html);
    libxml_clear_errors(); // Limpa os erros

    $xpath = new DOMXPath($dom);

    // Selecionar a tabela de resultados
    $tabela = $xpath->query('//div[@class="seven columns"]/table[@class="twelve"]')->item(0);

    if ($tabela) {
        $headers = [];
        $header_row = $xpath->query('./thead/tr/th', $tabela);
        foreach ($header_row as $th) {
            $headers[] = trim($th->textContent);
        }

        $resultados_formatado = array_fill_keys(array_slice($headers, 1), []);
        $linhas = $xpath->query('./tbody/tr', $tabela);

        foreach ($linhas as $linha) {
            $colunas = $xpath->query('./td', $linha);
            if ($colunas->length === count($headers)) {
                $ordem = trim($colunas->item(0)->textContent);
                for ($i = 1; $i < count($headers); $i++) {
                    $header_texto = $headers[$i];
                    $resultado_texto = trim($colunas->item($i)->textContent);
                    $bicho_nome = $colunas->item($i)->getAttribute('title');
                    $resultados_formatado[$header_texto][] = [
                        'ordem' => $ordem,
                        'resultado' => $resultado_texto,
                        'bicho' => $bicho_nome
                    ];
                }
            }
        }

        $json_data =  json_encode($resultados_formatado);

        $data = json_decode($json_data, true);

        foreach ($data as $tipo_sorteio => $resultados) {
            foreach ($resultados as $resultado) {
               $data = [];
               $numero_bicho = explode("-", $resultado['resultado'])[1];
               $data['tipo_sorteio'] = $tipo_sorteio;
               $data['ordem'] = $resultado['ordem'];
               $data['resultado'] = $resultado['resultado'];
               $data['bicho'] = $numero_bicho;
               $data['dia_semana'] = obterDiaSemana();

               $create = new Create();
               $create->ExeCreate("resultados", $data);
            }
        }

    } else {
        echo json_encode(['erro' => 'Tabela de resultados não encontrada.']);
    }


} catch (Exception $e) {
//    echo json_encode(['error' => $e->getMessage(), 'success' => false]);
}


function obterDiaSemana() {
    $diaSemanaIngles = date('l');

    $diasPortugues = [
        'Sunday'    => 'Domingo',
        'Monday'    => 'Segunda-feira',
        'Tuesday'   => 'Terça-feira',
        'Wednesday' => 'Quarta-feira',
        'Thursday'  => 'Quinta-feira',
        'Friday'    => 'Sexta-feira',
        'Saturday'  => 'Sábado'
    ];

    return $diasPortugues[$diaSemanaIngles];
}
?>
