<?php
require "_App/Config.inc.php";

function obterDadosHistoricos()
{
    // Esta é uma função de exemplo. Você precisará implementá-la
    // para buscar seus dados de alguma fonte (arquivo, banco de dados, etc.).
    return [
        ['data' => '2025-04-01', 'dia_semana' => 'Terça', 'tipo_sorteio' => 'PPT', 'resultado' => '1234-05', 'bicho' => 'Cachorro'],
        ['data' => '2025-04-01', 'dia_semana' => 'Terça', 'tipo_sorteio' => 'PTM', 'resultado' => '5678-10', 'bicho' => 'Coelho'],
        ['data' => '2025-04-02', 'dia_semana' => 'Quarta', 'tipo_sorteio' => 'PPT', 'resultado' => '9012-15', 'bicho' => 'Jacaré'],
        ['data' => '2025-04-01', 'dia_semana' => 'Terça', 'tipo_sorteio' => 'PPT', 'resultado' => '3456-20', 'bicho' => 'Perú'],
        ['data' => '2025-04-02', 'dia_semana' => 'Quarta', 'tipo_sorteio' => 'PTM', 'resultado' => '7890-25', 'bicho' => 'Vaca'],
        ['data' => '2025-04-03', 'dia_semana' => 'Quinta', 'tipo_sorteio' => 'PPT', 'resultado' => '2345-01', 'bicho' => 'Avestruz'],
        ['data' => '2025-04-03', 'dia_semana' => 'Quinta', 'tipo_sorteio' => 'PPT', 'resultado' => '6789-05', 'bicho' => 'Cachorro'],
        ['data' => '2025-04-01', 'dia_semana' => 'Terça', 'tipo_sorteio' => 'PPT', 'resultado' => '0123-10', 'bicho' => 'Coelho'],
        ['data' => '2025-04-02', 'dia_semana' => 'Quarta', 'tipo_sorteio' => 'PPT', 'resultado' => '4567-15', 'bicho' => 'Jacaré'],
        ['data' => '2025-04-02', 'dia_semana' => 'Quarta', 'tipo_sorteio' => 'PTM', 'resultado' => '8901-20', 'bicho' => 'Perú'],
        ['data' => '2025-04-04', 'dia_semana' => 'Sexta', 'tipo_sorteio' => 'PPT', 'resultado' => '5432-25', 'bicho' => 'Vaca'],
        ['data' => '2025-04-04', 'dia_semana' => 'Sexta', 'tipo_sorteio' => 'PTM', 'resultado' => '9876-01', 'bicho' => 'Avestruz'],
        ['data' => '2025-04-03', 'dia_semana' => 'Quinta', 'tipo_sorteio' => 'PPT', 'resultado' => '3210-05', 'bicho' => 'Cachorro'],
        // ... adicione mais dados históricos aqui ...
    ];
}

function analisarBichosMaisAcertivos(array $dadosHistoricos)
{
    $analise = [];
    $diasSemana = ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'];
    $tiposSorteio = ['PPT', 'PTM', 'PT', 'PTV'];

    foreach ($diasSemana as $dia) {
        $analise[$dia] = [];
        foreach ($tiposSorteio as $tipo) {
            $resultadosDiaTipo = array_filter($dadosHistoricos, function ($resultado) use ($dia, $tipo) {
                return $resultado['dia_semana'] === $dia && $resultado['tipo_sorteio'] === $tipo;
            });

            if (!empty($resultadosDiaTipo)) {
                $contagemBichos = [];
                foreach ($resultadosDiaTipo as $resultado) {
                    $bicho = $resultado['bicho'];
                    $contagemBichos[$bicho] = (!empty($contagemBichos[$bicho]) ? $contagemBichos[$bicho] : 0) + 1;
                }

                // Calcular a porcentagem
                $totalSorteios = count($resultadosDiaTipo);
                $porcentagensBichos = [];
                foreach ($contagemBichos as $bicho => $frequencia) {
                    $porcentagensBichos[$bicho] = ($frequencia / $totalSorteios) * 100;
                }

                // Ordenar por porcentagem decrescente
                arsort($porcentagensBichos);

                // Pegar os top 10
                $top10Bichos = array_slice($porcentagensBichos, 0, 10, true);
                $analise[$dia][$tipo] = $top10Bichos;
            } else {
                $analise[$dia][$tipo] = "Sem dados suficientes";
            }
        }
    }

    return $analise;
}

// Obter os dados históricos
$read = new Read();
$read->ExeRead("resultados");

$dados = $read->getResult();

//$dados = obterDadosHistoricos();

// Analisar os bichos mais "acertivos"
$analisePreditiva = analisarBichosMaisAcertivos($dados);

// Exibir os resultados da análise
echo "<pre>";
print_r($analisePreditiva);
echo "</pre>";

?>