<?php

// CONFIGRAÇÕES DO BANCO ####################
define('HOST', 'localhost');
define('USER', 'root');
define('PASS', '');
define('DBSA', 'jogo_bicho');

// DEFINE SERVIDOR DE E-MAIL ################
define('MAILUSER', 'contato@hospitaldosmartphone.com');
define('MAILPASS', 'Hosp123456');
define('MAILPORT', '465');
define('MAILHOST', 'mail.hospitaldosmartphone.com');

// DEFINE A BASE DO SITE ####################
define('HOME', 'http://localhost/jogo-bicho');

$getUrl = strip_tags(trim(filter_input(INPUT_GET, 'url', FILTER_DEFAULT)));
$setUrl = (empty($getUrl) ? 'home' : $getUrl);
$Url = explode('/', $setUrl);

date_default_timezone_set('america/sao_paulo');

// AUTO LOAD DE CLASSES ####################
function autoload_de_teste($Class){

    $cDir = ['Conn', 'Helpers', 'Library/Mailer', 'Models'];
    $iDir = null;

    foreach ($cDir as $dirName):
        if (!$iDir && file_exists(__DIR__ . DIRECTORY_SEPARATOR . $dirName . DIRECTORY_SEPARATOR . $Class . '.class.php') && !is_dir(__DIR__ . DIRECTORY_SEPARATOR . $dirName . DIRECTORY_SEPARATOR . $Class . '.class.php')):
            include_once (__DIR__ . DIRECTORY_SEPARATOR . $dirName . DIRECTORY_SEPARATOR . $Class . '.class.php');
            $iDir = true;
        endif;
    endforeach;

    if (!$iDir):
        trigger_error("Não foi possível incluir {$Class}.class.php", E_USER_ERROR);
        die;
    endif;
}

spl_autoload_register("autoload_de_teste");


//WSErro :: Exibe erros lançados :: Front
function WSErro($ErrMsg, $ErrNo, $ErrDie = null) {
    $CssClass = ($ErrNo == E_USER_NOTICE ? WS_INFOR : ($ErrNo == E_USER_WARNING ? WS_ALERT : ($ErrNo == E_USER_ERROR ? WS_ERROR : $ErrNo)));
    echo "<p class=\"trigger {$CssClass}\">{$ErrMsg}<span class=\"ajax_close\"></span></p>";

    if ($ErrDie):
        die;
    endif;
}

//PHPErro :: personaliza o gatilho do PHP
function PHPErro($ErrNo, $ErrMsg, $ErrFile, $ErrLine) {
    $CssClass = ($ErrNo == E_USER_NOTICE ? WS_INFOR : ($ErrNo == E_USER_WARNING ? WS_ALERT : ($ErrNo == E_USER_ERROR ? WS_ERROR : $ErrNo)));
    echo "<p class=\"trigger {$CssClass}\">";
    echo "<b>Erro na Linha: #{$ErrLine} ::</b> {$ErrMsg}<br>";
    echo "<small>{$ErrFile}</small>";
    echo "<span class=\"ajax_close\"></span></p>";

    if ($ErrNo == E_USER_ERROR):
        die;
    endif;
}


set_error_handler('PHPErro');

function msgSuccess($msg) {
    echo '<div class="alert alert-success">'. $msg .
        '<button type = "button" class = "close" data-dismiss = "alert" aria-label = "Close"> <span aria-hidden = "true">&times;'.
        '</span></button></div>';
}

function msgDanger($msg) {
    echo '<div class="alert alert-danger">'. $msg .
        '<button type = "button" class = "close" data-dismiss = "alert" aria-label = "Close"> <span aria-hidden = "true">&times;'.
        '</span></button></div>';
}
